<?php

require_once '../model/database.php';
require_once '../model/vendor_model.php';
require_once 'header.php';

if (isset($_GET['id'])) {
    $vend_id = $_GET['id'];
    $vendor = get_vendor_by_id($conn, $vend_id);

    if ($vendor) {
        echo "<h1>Delete Vendor</h1>";
        echo "<nav><a href='../index.php'>Home</a> | <a href='product_info.php'>Product Info</a> | <a href='manage_vendors.php'>Vendors</a></nav>";

        if (isset($_POST['delete'])) {
            // Set vendor_id to NULL for products linked to this vendor
            update_products_vendor_to_null($conn, $vend_id);
            // Then delete the vendor
            delete_vendor($conn, $vend_id);
            echo "<p>Vendor deleted. Products' vendor set to NULL.</p>";
            echo "<a href='manage_vendors.php'>Back to Vendors</a>";
        } else {
            ?>
            <p>Are you sure you want to delete vendor: <?php echo $vendor['vend_name']; ?>? Products will remain, but the vendor will be set to NULL.</p>
            <form method="post">
                <input type="submit" name="delete" value="Delete">
            </form>
            <?php
        }
    } else {
        echo "<p>Vendor not found.</p>";
    }
} else {
    echo "<p>Vendor ID not provided.</p>";
}

require_once 'footer.php';
?>
